<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1\BrandRegistration;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 *
 * @property string $accountSid
 * @property string $brandSid
 * @property string $brandVettingSid
 * @property \DateTime $dateUpdated
 * @property \DateTime $dateCreated
 * @property string $vettingId
 * @property string $vettingClass
 * @property string $vettingStatus
 * @property string $vettingProvider
 * @property string $url
 */
class BrandVettingInstance extends InstanceResource {
    /**
     * Initialize the BrandVettingInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $brandSid A2P BrandRegistration Sid
     */
    public function __construct(Version $version, array $payload, string $brandSid) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'brandSid' => Values::array_get($payload, 'brand_sid'),
            'brandVettingSid' => Values::array_get($payload, 'brand_vetting_sid'),
            'dateUpdated' => Deserialize::dateTime(Values::array_get($payload, 'date_updated')),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'vettingId' => Values::array_get($payload, 'vetting_id'),
            'vettingClass' => Values::array_get($payload, 'vetting_class'),
            'vettingStatus' => Values::array_get($payload, 'vetting_status'),
            'vettingProvider' => Values::array_get($payload, 'vetting_provider'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['brandSid' => $brandSid, ];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Messaging.V1.BrandVettingInstance]';
    }
}