<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Media\V1;

use Twilio\Options;
use Twilio\Values;

abstract class MediaProcessorOptions {
    /**
     * @param array $extensionEnvironment The Media Extension environment
     * @param string $statusCallback The URL to send MediaProcessor event updates
     *                               to your application
     * @param string $statusCallbackMethod The HTTP method Twilio should use to
     *                                     call the `status_callback` URL
     * @return CreateMediaProcessorOptions Options builder
     */
    public static function create(array $extensionEnvironment = Values::ARRAY_NONE, string $statusCallback = Values::NONE, string $statusCallbackMethod = Values::NONE): CreateMediaProcessorOptions {
        return new CreateMediaProcessorOptions($extensionEnvironment, $statusCallback, $statusCallbackMethod);
    }

    /**
     * @param string $order The sort order of the list
     * @param string $status Status to filter by
     * @return ReadMediaProcessorOptions Options builder
     */
    public static function read(string $order = Values::NONE, string $status = Values::NONE): ReadMediaProcessorOptions {
        return new ReadMediaProcessorOptions($order, $status);
    }
}

class CreateMediaProcessorOptions extends Options {
    /**
     * @param array $extensionEnvironment The Media Extension environment
     * @param string $statusCallback The URL to send MediaProcessor event updates
     *                               to your application
     * @param string $statusCallbackMethod The HTTP method Twilio should use to
     *                                     call the `status_callback` URL
     */
    public function __construct(array $extensionEnvironment = Values::ARRAY_NONE, string $statusCallback = Values::NONE, string $statusCallbackMethod = Values::NONE) {
        $this->options['extensionEnvironment'] = $extensionEnvironment;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
    }

    /**
     * User-defined environment variables for the Media Extension, represented as a JSON dictionary of key/value strings. See the documentation for the specific [Media Extension](/docs/live/api/media-extensions-overview) you are using for more information about whether you need to provide this.
     *
     * @param array $extensionEnvironment The Media Extension environment
     * @return $this Fluent Builder
     */
    public function setExtensionEnvironment(array $extensionEnvironment): self {
        $this->options['extensionEnvironment'] = $extensionEnvironment;
        return $this;
    }

    /**
     * The URL to which Twilio will send asynchronous webhook requests for every MediaProcessor event. See [Status Callbacks](/docs/live/status-callbacks) for details.
     *
     * @param string $statusCallback The URL to send MediaProcessor event updates
     *                               to your application
     * @return $this Fluent Builder
     */
    public function setStatusCallback(string $statusCallback): self {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The HTTP method Twilio should use to call the `status_callback` URL. Can be `POST` or `GET` and the default is `POST`.
     *
     * @param string $statusCallbackMethod The HTTP method Twilio should use to
     *                                     call the `status_callback` URL
     * @return $this Fluent Builder
     */
    public function setStatusCallbackMethod(string $statusCallbackMethod): self {
        $this->options['statusCallbackMethod'] = $statusCallbackMethod;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Media.V1.CreateMediaProcessorOptions ' . $options . ']';
    }
}

class ReadMediaProcessorOptions extends Options {
    /**
     * @param string $order The sort order of the list
     * @param string $status Status to filter by
     */
    public function __construct(string $order = Values::NONE, string $status = Values::NONE) {
        $this->options['order'] = $order;
        $this->options['status'] = $status;
    }

    /**
     * The sort order of the list by `date_created`. Can be: `asc` (ascending) or `desc` (descending) with `desc` as the default.
     *
     * @param string $order The sort order of the list
     * @return $this Fluent Builder
     */
    public function setOrder(string $order): self {
        $this->options['order'] = $order;
        return $this;
    }

    /**
     * Status to filter by, with possible values `started`, `ended` or `failed`.
     *
     * @param string $status Status to filter by
     * @return $this Fluent Builder
     */
    public function setStatus(string $status): self {
        $this->options['status'] = $status;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Media.V1.ReadMediaProcessorOptions ' . $options . ']';
    }
}