<?php

namespace Tests\Browser\Modules\SupportTicket;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\SupportTicket\Entities\SupportTicket;
use Modules\SupportTicket\Entities\SupportTicketFile;
use Modules\SupportTicket\Entities\TicketCategory;
use Modules\SupportTicket\Entities\TicketPriority;
use Modules\SupportTicket\Entities\TicketStatus;
use Tests\DuskTestCase;
use Twilio\TwiML\Voice\Pause;

class TicketTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {

        $support_tickets = SupportTicket::all();

        if(count($support_tickets) > 0){
            foreach($support_tickets as $ticket){
                $files = SupportTicketFile::where('attachment_id', $ticket->id)->get();
                if(count($files) > 0){
                    foreach($files as $file){
                        if(File::exists(public_path($file->url)) && $file->url != null){
                            File::delete(public_path($file->url));
                        }
                        $file->delete();
                    }
                }
                $ticket->delete();
            }
            
        }        
        
        $categories = TicketCategory::where('id', '>', 3)->pluck('id');
        TicketCategory::destroy($categories);

        $priorities = TicketPriority::where('id', '>', 3)->pluck('id');
        TicketPriority::destroy($priorities);

        $statuses = TicketStatus::where('id', '>', 4)->pluck('id');
        TicketStatus::destroy($statuses);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page_admin()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/admin/ticket/tickets')
                    ->assertSee('Support Ticket');
        });
    }

    public function test_for_visit_create_page_admin()
    {
        $this->test_for_visit_index_page_admin();
        $this->browse(function (Browser $browser) {
            $rand = mt_rand(10,99);
            $time = time();
            $time = substr($time,6);
            $pre = 'TIC-';
            $browser->click('#add_new')
                    ->assertPathIs('/admin/ticket/tickets/create')
                    ->assertSee('Open a Ticket')
                    ->type('#subject', $this->faker->title)
                    ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div.col-lg-3 > div > div > input', $pre.$rand.$time)
                    ->click('#add_new_priority')
                    ->whenAvailable('#add_priority_form', function($modal){
                        $modal->type('div > div > div.col-md-12 > div > input', $this->faker->name)
                            ->click('div > div > div.col-lg-12.mt-40.text-center > button');
                    })
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Added successfully!')
                    ->pause(5000)
                    ->click('#priority_list_div > div > div.nice-select.primary_select.mb-15')
                    ->pause(1000)
                    ->click('#priority_list_div > div > div.nice-select.primary_select.mb-15.open > ul > li:nth-child(2)')
                    ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div:nth-child(4) > div > div')
                    ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div:nth-child(4) > div > div > ul > li:nth-child(2)')
                    ->click('#add_new_category')
                    ->whenAvailable('#add_category_form', function($modal){
                        $modal->type('div > div > div.col-md-12 > div > input', $this->faker->name)
                            ->click('div > div > div.col-lg-12.mt-40.text-center > button');

                    })
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Added successfully!')
                    ->pause(5000)
                    ->click('#category_list_div > div > div.nice-select.primary_select.mb-15')
                    ->pause(1000)
                    ->click('#category_list_div > div > div.nice-select.primary_select.mb-15.open > ul > li:nth-child(2)')
                    ->click('#add_new_status')
                    ->whenAvailable('#add_status_form', function($modal){
                        $modal->type('div > div > div.col-md-12 > div > input', $this->faker->name)
                            ->click('div > div > div.col-lg-12.mt-40.text-center > button');
                    })
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Added successfully!')
                    ->pause(5000)
                    ->click('#status_list_div > div > div.nice-select.primary_select.mb-15')
                    ->pause(1000)
                    ->click('#status_list_div > div > div.nice-select.primary_select.mb-15.open > ul > li:nth-child(2)')
                    ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div:nth-child(7) > div > div')
                    ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div:nth-child(7) > div > div > ul > li:nth-child(4)')
                    ->attach('#ticket_file', __DIR__.'/files/ticket_file_1.png')
                    ->click('#ticket_file_add')
                    ->pause(1000)
                    ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div:nth-child(8) > div > div:nth-child(2) > div.col-1.mt-32 > button')
                    ->click('#ticket_file_add')
                    ->pause(1000)
                    ->attach('#ticket_file_1', __DIR__.'/files/ticket_file_2.pdf')
                    ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(2) > div.col-xl-12 > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                    ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div > div > button')
                    ->assertPathIs('/admin/ticket/tickets')
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Created successfully!');

        });
    }

    public function test_for_edit_ticket_admin()
    {
        $this->test_for_visit_create_page_admin();
        $this->browse(function (Browser $browser) {
            $ticket = SupportTicket::latest()->first();
            $rand = mt_rand(10,99);
            $time = time();
            $time = substr($time,6);
            $pre = 'TIC-';
            $browser->pause(10000)
                ->click('#dataListTable > tbody > tr:nth-child(1) > td:nth-child(9) > div > button')
                ->click('#dataListTable > tbody > tr:nth-child(1) > td:nth-child(9) > div > div > a:nth-child(2)')
                ->assertPathIs('/admin/ticket/tickets/'.$ticket->id.'/edit')
                ->assertSee('Update Ticket')
                ->type('#subject', $this->faker->title)
                ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div.col-lg-3 > div > div > input', $pre.$rand.$time)
                ->click('#add_new_priority')
                ->whenAvailable('#add_priority_form', function($modal){
                    $modal->type('div > div > div.col-md-12 > div > input', $this->faker->name)
                        ->click('div > div > div.col-lg-12.mt-40.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!')
                ->pause(5000)
                ->click('#priority_list_div > div > div.nice-select.primary_select.mb-15')
                ->pause(1000)
                ->click('#priority_list_div > div > div.nice-select.primary_select.mb-15.open > ul > li:nth-child(2)')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div:nth-child(4) > div > div')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div:nth-child(4) > div > div > ul > li:nth-child(3)')
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form', function($modal){
                    $modal->type('div > div > div.col-md-12 > div > input', $this->faker->name)
                        ->click('div > div > div.col-lg-12.mt-40.text-center > button');

                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!')
                ->pause(5000)
                ->click('#category_list_div > div > div.nice-select.primary_select.mb-15')
                ->pause(1000)
                ->click('#category_list_div > div > div.nice-select.primary_select.mb-15.open > ul > li:nth-child(2)')
                ->click('#add_new_status')
                ->whenAvailable('#add_status_form', function($modal){
                    $modal->type('div > div > div.col-md-12 > div > input', $this->faker->name)
                        ->click('div > div > div.col-lg-12.mt-40.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!')
                ->pause(5000)
                ->click('#status_list_div > div > div.nice-select.primary_select.mb-15')
                ->pause(1000)
                ->click('#status_list_div > div > div.nice-select.primary_select.mb-15.open > ul > li:nth-child(2)')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div:nth-child(7) > div > div')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div:nth-child(7) > div > div > ul > li:nth-child(3)')
                ->pause(10000)
                ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div:nth-child(8) > div > div:nth-child(2) > div:nth-child(1) > span > a')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!')
                ->pause(2000)
                ->attach('#ticket_file', __DIR__.'/files/ticket_file_1.png')
                ->click('#ticket_file_add')
                ->pause(2000)
                ->attach('#ticket_file_1', __DIR__.'/files/ticket_file_2.pdf')
                ->type('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(3) > div.col-xl-12 > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->click('#main-content > section > div > div > div:nth-child(2) > div > form > div:nth-child(4) > div > div > button')
                ->assertPathIs('/admin/ticket/tickets')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

                      
        });
    }


    public function test_for_show_and_comment_admin()
    {
        $this->test_for_visit_create_page_admin();
        $this->browse(function (Browser $browser) {
            $ticket = SupportTicket::latest()->first();
            $browser->pause(10000)
                ->click('#dataListTable > tbody > tr:nth-child(1) > td:nth-child(9) > div > button')
                ->click('#dataListTable > tbody > tr > td:nth-child(9) > div > div > a:nth-child(1)')
                ->assertPathIs('/admin/ticket/tickets/'.$ticket->id)
                ->assertSee('Ticket Info')
                ->type('#main-content > section > div > div > div.col-lg-8.col-xl-9 > div > div > div.col-lg-12 > form > div > div.col-12.mb-30 > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->attach('#ticket_file', __DIR__.'/files/ticket_file_1.png')
                ->click('#ticket_file_add')
                ->pause(2000)
                ->click('#main-content > section > div > div > div.col-lg-8.col-xl-9 > div > div > div.col-lg-12 > form > div > div:nth-child(4) > div > div:nth-child(2) > div.col-1.mt_5 > button')
                ->click('#ticket_file_add')
                ->pause(2000)
                ->attach('#ticket_file_1', __DIR__.'/files/ticket_file_2.pdf')
                ->click('#main-content > section > div > div > div.col-lg-8.col-xl-9 > div > div > div.col-lg-12 > form > div > div:nth-child(5) > div > div')
                ->click('#main-content > section > div > div > div.col-lg-8.col-xl-9 > div > div > div.col-lg-12 > form > div > div:nth-child(5) > div > div > ul > li:nth-child(3)')
                ->click('#main-content > section > div > div > div.col-lg-8.col-xl-9 > div > div > div.col-lg-12 > form > div > div:nth-child(6) > div > button')
                ->assertPathIs('/admin/ticket/tickets/'.$ticket->id)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Send successfully!')
                ->click('#main-content > section > div > div > div.col-12 > div > div.table_btn_wrap > ul > li > div > button')
                ->click('#main-content > section > div > div > div.col-12 > div > div.table_btn_wrap > ul > li > div > div > a')
                ->assertPathIs('/admin/ticket/tickets/'.$ticket->id.'/edit')
                ->assertSee('Update Ticket')
                ->visit('/admin/ticket/tickets/'.$ticket->id)
                ->click('#main-content > section > div > div > div.col-12 > div > div.table_btn_wrap > ul > li > div > button')
                ->click('#main-content > section > div > div > div.col-12 > div > div.table_btn_wrap > ul > li > div > div > button')
                ->whenAvailable('#deleteForm', function($modal){
                    $modal->click('input.primary-btn.fix-gr-bg')
                        ->assertPathIs('/admin/ticket/tickets');

                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');

        });
    }

    public function test_for_change_asign(){
        $this->test_for_visit_create_page_admin();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#dataListTable > tbody > tr > td:nth-child(8) > div > div > form > div')
                ->click('#dataListTable > tbody > tr > td:nth-child(8) > div > div > form > div > ul > li:nth-child(4)')
                ->click('#dataListTable > tbody > tr > td:nth-child(8) > div > div > form > button')
                ->assertPathIs('/admin/ticket/tickets')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });        
    }

    public function test_for_delete_ticket(){
        $this->test_for_visit_create_page_admin();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#dataListTable > tbody > tr:nth-child(1) > td:nth-child(9) > div > button')
                ->click('#dataListTable > tbody > tr > td:nth-child(9) > div > div > a.dropdown-item.delete_ticket')
                ->whenAvailable('#deleteForm', function($modal){
                    $modal->click('input.primary-btn.fix-gr-bg')
                        ->assertPathIs('/admin/ticket/tickets');

                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');

        });        
    }


    public function test_for_my_ticket_index(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/admin/ticket/assigned-ticket')
                ->assertSee('Ticket List');
        });
    }

    public function test_for_filter_my_support_ticket(){
        $rand = mt_rand(10,99);
        $time = time();
        $time = substr($time,6);
        $pre = 'TIC-';
        $ticket = SupportTicket::create([
            'reference_no' => $pre.$time.$rand,
            'subject' => $this->faker->title,
            'description' => $this->faker->paragraph,
            'category_id' => 1,
            'priority_id' => 1,
            'status_id' => 1,
            'user_id' => 4,
            'refer_id' => 1
        ]);

        $this->test_for_my_ticket_index();

        $this->browse(function (Browser $browser) use($ticket) {
            $browser->click('#search_btn')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Please at least one item.')
                ->click('#main-content > section > div > div > div:nth-child(1) > form > div > div:nth-child(1) > div > div')
                ->click('#main-content > section > div > div > div:nth-child(1) > form > div > div:nth-child(1) > div > div > ul > li:nth-child(2)')
                ->click('#main-content > section > div > div > div:nth-child(1) > form > div > div:nth-child(2) > div > div')
                ->click('#main-content > section > div > div > div:nth-child(1) > form > div > div:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->click('#main-content > section > div > div > div:nth-child(1) > form > div > div:nth-child(3) > div > div')
                ->click('#main-content > section > div > div > div:nth-child(1) > form > div > div:nth-child(3) > div > div > ul > li:nth-child(2)')
                ->pause(4000)
                ->click('#search_btn')
                ->assertPathIs('/admin/ticket/assigned-ticket')
                ->pause(8000)
                ->assertSeeAnythingIn('#dataListTable > tbody > tr > td:nth-child(2)')
                ->click('#dataListTable > tbody > tr > td:nth-child(8) > div > button')
                ->click('#dataListTable > tbody > tr > td:nth-child(8) > div > div > a')
                ->assertPathIs('/admin/ticket/tickets/'.$ticket->id)
                ->assertSee('Ticket Info');
        });

    }

}
