<?php

namespace Tests\Browser\Modules\Setup;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Setup\Entities\Department;
use Tests\DuskTestCase;

class DepartmentTest extends DuskTestCase
{
    use WithFaker;


    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $departments = Department::where('id', '>', 3)->pluck('id');
        Department::destroy($departments);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/hr/departments')
                ->assertSee('Department List');
        });
    }

    public function test_for_create_department(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#add_new_btn')
                ->whenAvailable('#item_create_form', function($modal){
                    $modal->type('#name', 'test-department')
                        ->type('div > div:nth-child(2) > div > textarea', $this->faker->paragraph)
                        ->click('div > div:nth-child(3) > div > ul > li:nth-child(2) > label > span')
                        ->click('div > div.col-lg-12.text-center > div > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!');

        });
    }

    public function test_for_validate_create_form(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#add_new_btn')
                ->whenAvailable('#item_create_form', function($modal){
                    $modal->type('#name', '')
                        ->type('div > div:nth-child(2) > div > textarea', '')
                        ->click('div > div:nth-child(3) > div > ul > li:nth-child(2) > label > span')
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->waitForTextIn('#name_error', 'The name field is required.', 25)
                        ->pause(2000)
                        ->type('#name', 'Sales')
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->waitForTextIn('#name_error', 'The name has already been taken.', 25);
                });
        });
    }

    public function test_for_edit_department(){
        $this->test_for_create_department();
        $this->browse(function (Browser $browser) {
            $browser->pause(1000)
                ->type('#DataTables_Table_1_filter > label > input[type=search]', 'test-department')
                ->pause(1000)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > div > a.dropdown-item.edit_department')
                ->whenAvailable('#item_edit_form', function($modal){
                    $modal->type('div > div.col-lg-12.col-md-12.col-sm-12 > div > input', 'test-department-edit')
                        ->type('div > div:nth-child(2) > div > textarea', $this->faker->paragraph)
                        ->click('div > div:nth-child(3) > div > ul > li:nth-child(1) > label > span')
                        ->pause(6000)
                        ->click('div > div.col-lg-12.text-center > div > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_form(){
        $this->test_for_create_department();
        $this->browse(function (Browser $browser) {
            $browser->pause(1000)
                ->type('#DataTables_Table_1_filter > label > input[type=search]', 'test-department')
                ->pause(1000)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > div > a.dropdown-item.edit_department')
                ->whenAvailable('#item_edit_form', function($modal){
                    $modal->type('div > div.col-lg-12.col-md-12.col-sm-12 > div > input', 'Sales')
                        ->click('div > div:nth-child(3) > div > ul > li:nth-child(1) > label > span')
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->waitForTextIn('div > div.col-lg-12.col-md-12.col-sm-12 > div > span', 'The name has already been taken.', 25)
                        ->type('div > div.col-lg-12.col-md-12.col-sm-12 > div > input', '')
                        ->click('div > div.col-lg-12.text-center > div > button')
                        ->pause(2000)
                        ->waitForTextIn('div > div.col-lg-12.col-md-12.col-sm-12 > div > span', 'The name field is required.', 25);
                });
        });
    }

    public function test_for_delete_department(){
        $this->test_for_create_department();
        $this->browse(function (Browser $browser) {
            $browser->pause(1000)
                ->type('#DataTables_Table_1_filter > label > input[type=search]', 'test-department')
                ->pause(5000)
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr:nth-child(1) > td:nth-child(5) > div > div > a.dropdown-item.delete_department')
                ->whenAvailable('#item_delete_form', function($modal){
                    $modal->click('#dataDeleteBtn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });        
    }

}
