<?php

namespace Tests\Browser\Modules\Product;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Product\Entities\Attribute;
use Modules\Product\Entities\AttributeValue;
use Tests\DuskTestCase;

class AttributesTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $atrributes = Attribute::where('name', '!=', 'Color')->get();

        foreach($atrributes as $attribute){
            $values = $attribute->values->pluck('id');
            AttributeValue::destroy($values);
            $attribute->delete();
        }


        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/product/attribute-list')
                    ->assertSee('Attribute List');
        });
    }

    public function test_for_create_attribute(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#name', $this->faker->name)
                ->type('#variantForm > div > div > div:nth-child(2) > div > textarea', $this->faker->paragraph)
                ->click('#variantForm > div > div > div.col-xl-12 > div > ul > li:nth-child(2) > label > span')
                ->type('#variantForm > div > div > div:nth-child(4) > div > div > div > table > tbody > tr > td:nth-child(1) > input', $this->faker->name)
                ->click('#variantForm > div > div > div:nth-child(4) > div > div > div > table > tbody > tr > td.pl-0.pb-0.pr-0 > div > button')
                ->click('#variantForm > div > div > div:nth-child(4) > div > div > div > table > tbody > tr:nth-child(2) > td.pl-0.pb-0.pr-0.remove > div > i')
                ->click('#variantForm > div > div > div:nth-child(4) > div > div > div > table > tbody > tr > td.pl-0.pb-0.pr-0 > div > button')
                ->type('#variantForm > div > div > div:nth-child(4) > div > div > div > table > tbody > tr:nth-child(2) > td:nth-child(1) > input', $this->faker->name)
                ->click('#variantForm > div > div > div:nth-child(5) > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_edit_attribute(){
        $this->test_for_create_attribute();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1 > tbody > tr.odd > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.odd > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.odd > td:nth-child(5) > div > div > a.dropdown-item.edit_variant')
                ->waitFor('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td:nth-child(1) > input', 25)
                ->type('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td:nth-child(1) > input', $this->faker->name)
                ->type('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(3) > td:nth-child(1) > input', $this->faker->name)
                ->click('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td.pl-0.pb-0.pr-0 > div > button')
                ->pause(1000)
                ->type('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(4) > td:nth-child(1) > input', $this->faker->name)
                ->click('#save_button_parent')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_edit_color_attribute(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > div > div > a.dropdown-item.edit_variant')
                ->waitFor('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td.pl-0.pb-0.pr-0 > div > button', 30)
                ->type('#attributeEditForm > div > div > div:nth-child(3) > div > textarea', $this->faker->paragraph)
                ->click('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td:nth-child(1) > span > input')
                ->pause(2000)
                ->click('div.sp-container.sp-light.sp-input-disabled.sp-alpha-enabled.sp-clear-enabled.sp-palette-buttons-disabled.sp-initial-disabled > div.sp-palette-container > div.sp-palette.sp-thumb.sp-cf > div.sp-cf.sp-palette-row.sp-palette-row-0 > span:nth-child(1)')
                ->pause(1000)
                ->click('#attributeEditForm > div > div > div:nth-child(2) > div > label')
                ->type('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td:nth-child(2) > input', 'Black')
                ->click('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td.pl-0.pb-0.pr-0 > div > button')
                ->click('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(3) > td:nth-child(1) > span > input')
                ->pause(1000)
                ->click('div:nth-child(65) > div.sp-palette-container > div.sp-palette.sp-thumb.sp-cf > div.sp-cf.sp-palette-row.sp-palette-row-0 > span:nth-child(2)')
                ->pause(1000)
                ->click('#attributeEditForm > div > div > div:nth-child(2) > div > label')
                ->pause(1000)
                ->type('#attributeEditForm > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(3) > td:nth-child(2) > input', 'Gray')

                ->click('#save_button_parent')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
        
    }

    public function test_for_attribute_delete(){
        $this->test_for_create_attribute();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#DataTables_Table_1 > tbody > tr.odd > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.odd > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr.odd > td:nth-child(5) > div > div > a.dropdown-item.delete_attribute')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/product/attribute-list');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }

    public function test_for_show_attribute(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > div > div > a.dropdown-item.show_attribute')
                ->whenAvailable('#item_show > div > div > div.modal-body', function($modal){
                    $modal->assertSeeIn('div > div > div > div > table > tbody > tr:nth-child(1) > th', 'Attribute Name');
                });
        });
    }


}
