<?php

namespace Tests\Browser\Modules\HRM;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Tests\DuskTestCase;

class StaffManageTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $staffs = User::where('id', '>', 5)->get();
        foreach($staffs as $key => $staff){
            if($staff->staff){
                if(count($staff->staff->documents) > 0){
                    foreach($staff->staff->documents as $doc){
                        if (File::exists(public_path($doc->documents))) {
                            File::delete(public_path($doc->documents));
                        }
                        $doc->delete();
                    }
                }
                $staff->staff->delete();
            }
            if(File::exists(public_path($staff->avatar)) && $staff->avatar != null){
                File::delete(public_path($staff->avatar));
            }

            $staff->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/hr/staffs')
                ->assertSee('Staff List');
        });
    }

    public function test_for_add_new_staff(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->assertPathIs('/hr/staffs/create')
                ->assertSee('Add New Staff')
                ->click('#staff_addForm > div > div:nth-child(3) > div > div')
                ->click('#staff_addForm > div > div:nth-child(3) > div > div > ul > li:nth-child(3)')
                ->click('#staff_addForm > div > div:nth-child(4) > div > div')
                ->click('#staff_addForm > div > div:nth-child(4) > div > div > ul > li:nth-child(3)')
                ->type('#staff_addForm > div > div:nth-child(5) > div > input', 'test99@test.com')
                ->type('#staff_addForm > div > div:nth-child(6) > div > input', $this->faker->name)
                ->type('#staff_addForm > div > div:nth-child(7) > div > input', $this->faker->name)
                ->type('#staff_addForm > div > div:nth-child(8) > div > input', $this->faker->phoneNumber)
                ->type('#staff_addForm > div > div:nth-child(9) > div > input', '12345678')
                ->type('#date_of_birth', '11/10/1994')
                ->click('#staff_addForm > div > div:nth-child(9) > div > label')
                ->pause(1000)
                ->type('#address', 'test address')
                ->attach('#document_file_1', __DIR__.'/files/avatar.jpg')
                ->type('#staff_addForm > div > div:nth-child(14) > div > div > div > div > div > input', '07/15/2021')
                ->click('#staff_addForm > div > div:nth-child(15) > div > label')
                ->pause(1000)
                ->type('#staff_addForm > div > div:nth-child(15) > div > div > div > div > div > input', '11/15/2021')
                ->click('#staff_addForm > div > div:nth-child(14) > div > label')
                ->pause(1000)
                ->type('#bank_name', $this->faker->name)
                ->type('#bank_branch_name', $this->faker->name)
                ->type('#bank_account_name', $this->faker->name)
                ->type('#bank_account_number', rand(111111111111, 999999999999))
                ->click('#save_button_parent')
                ->assertPathIs('/hr/staffs')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_validate_create_form(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->assertPathIs('/hr/staffs/create')
                ->assertSee('Add New Staff')
                ->click('#save_button_parent')
                ->assertPathIs('/hr/staffs/create')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(3) > div > span', 'The role id field is required.')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(5) > div > span', 'The email field is required.')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(6) > div > span', 'The first name field is required.')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(9) > div > span', 'The password field is required.')
                ->assertSeeIn('#staff_addForm > div > div.col-xl-4.date_of_birth_div > div > span', 'The date of birth must be a date before date of joining.')
                ->assertSeeIn('#staff_addForm > div > div.col-xl-4.current_address_div > div > span', 'The address field is required.')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(14) > div > span', 'The date of joining must be a date after date of birth.')
                ->assertSeeIn('#staff_addForm > div > div:nth-child(15) > div > span', 'The leave applicable date must be a date after date of joining.');

        });        
    }

    public function test_for_edit_staff(){
        $this->test_for_add_new_staff();
        $this->browse(function (Browser $browser) {
            $staff_id = User::latest()->first()->id;
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test99@test.com')
                ->pause(1000)
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > div > a:nth-child(1)')
                ->assertPathIs('/hr/staffs/'.$staff_id.'/edit')
                ->assertSee('Edit Staff Info')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(4) > div > input', $this->faker->name)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(5) > div > input', $this->faker->name)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(6) > div > input', 'test98@test.com')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(7) > div > input', $this->faker->phoneNumber)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(8) > div > input', '123456789')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(9) > div > div')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(9) > div > div > ul > li:nth-child(2)')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(10) > div > div')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(10) > div > div > ul > li:nth-child(1)')
                ->type('#address', 'test address edit')
                ->type('#date_of_birth', '12/05/1994')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > label')
                ->pause(1000)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > div > div > div > div > input', '07/14/2021')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div.col-xl-4.date_of_birth_div > div > label')
                ->pause(1000)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(14) > div > div > div > div > div > input', '11/14/2021')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > label')
                ->pause(1000)
                ->attach('#document_file_1', __DIR__.'/files/avatar.jpg')
                ->type('#bank_name', $this->faker->name)
                ->type('#bank_branch_name', $this->faker->name)
                ->type('#bank_account_name', $this->faker->name)
                ->type('#bank_account_no', rand(111111111111, 999999999999))
                ->click('#save_button_parent')
                ->assertPathIs('/hr/staffs')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_form(){
        $this->test_for_add_new_staff();
        $this->browse(function (Browser $browser) {
            $staff_id = User::latest()->first()->id;
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test99@test.com')
                ->pause(1000)
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > div > a:nth-child(1)')
                ->assertPathIs('/hr/staffs/'.$staff_id.'/edit')
                ->assertSee('Edit Staff Info')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(4) > div > input', '')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(5) > div > input', '')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(6) > div > input', '')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(7) > div > input', '')
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(8) > div > input', '')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(9) > div > div')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(9) > div > div > ul > li:nth-child(2)')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(10) > div > div')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(10) > div > div > ul > li:nth-child(1)')
                ->type('#address', '')
                ->type('#date_of_birth', '12/05/2022')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > label')
                ->pause(1000)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > div > div > div > div > input', '07/14/2021')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div.col-xl-4.date_of_birth_div > div > label')
                ->pause(1000)
                ->type('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(14) > div > div > div > div > div > input', '07/01/2021')
                ->click('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > label')
                ->pause(1000)
                ->type('#bank_name', '')
                ->type('#bank_branch_name', '')
                ->type('#bank_account_name', '')
                ->type('#bank_account_no', '')
                ->click('#save_button_parent')
                ->assertPathIs('/hr/staffs/'.$staff_id.'/edit')
                ->assertSeeIn('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(4) > div > span', 'The first name field is required.')
                ->assertSeeIn('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(6) > div > span', 'The email field is required.')
                ->assertSeeIn('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div.col-xl-4.current_address_div > div > span', 'The address field is required.')
                ->assertSeeIn('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div.col-xl-4.date_of_birth_div > div > span', 'The date of birth must be a date before date of joining.')
                ->assertSeeIn('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(13) > div > span', 'The date of joining must be a date after date of birth.')
                ->assertSeeIn('#main-content > section > div.container-fluid.p-0 > div > div:nth-child(2) > div > form > div > div:nth-child(14) > div > span', 'The leave applicable date must be a date after date of joining.');
        });        
    }

    public function test_for_edit_page_image_delete(){
        $this->test_for_add_new_staff();
        $this->browse(function (Browser $browser) {
            $staff_id = User::latest()->first()->id;
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test99@test.com')
                ->pause(1000)
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > div > a:nth-child(1)')
                ->assertPathIs('/hr/staffs/'.$staff_id.'/edit')
                ->assertSee('Edit Staff Info')
                ->pause(5000)
                ->click('#documentCross > i')
                ->whenAvailable('#imgForm', function($modal){
                    $modal->click('#document_delete_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });        
    }

    public function test_for_show_staff(){
        $this->test_for_add_new_staff();
        $this->browse(function (Browser $browser) {
            $staff_id = User::latest()->first()->id;
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test99@test.com')
                ->pause(1000)
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > div > a:nth-child(2)')
                ->assertPathIs('/hr/staff/view/'.$staff_id)
                ->assertSee('Staff Info')
                ->click('#main-content > section > div > div > div.col-lg-9.staff-details > ul > li:nth-child(2) > a')
                ->pause(2000)
                ->click('#staffDocuments > div > div.text-right.mb-20 > button')
                ->whenAvailable('#document_create_form', function($modal) use($staff_id){
                    $modal->click('div > div.col-lg-12.text-center.mt-40 > div > button.primary-btn.fix-gr-bg')
                        ->pause(2000)
                        ->assertSeeIn('#create_name_error', 'The Name field is Required.')
                        ->assertSeeIn('#create_file_error', 'The File field is Required.')
                        ->type('#create_name', $this->faker->name)
                        ->attach('#document_file_1', __DIR__.'/files/avatar.jpg')
                        ->click('div > div.col-lg-12.text-center.mt-40 > div > button.primary-btn.fix-gr-bg')
                        ->assertPathIs('/hr/staff/view/'.$staff_id);
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Uploaded successfully!')
                ->click('#main-content > section > div > div > div.col-lg-9.staff-details > ul > li:nth-child(2) > a')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(2) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(2) > div > div > a:nth-child(1)')
                ->pause(2000)
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(2) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(2) > div > div > a:nth-child(2)')
                ->pause(4000)
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal) use($staff_id){
                    $modal->click('#delete_link')
                    ->assertPathIs('/hr/staff/view/'.$staff_id);
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!')
                ->click('#main-content > section > div > div > div.col-lg-9.staff-details > ul > li.nav-item.edit-button > a')
                ->assertPathIs('/hr/staffs/'.$staff_id.'/edit')
                ->assertSee('Staff Info');
                
                
        });        
    }

    public function test_for_delete_staff(){
        $this->test_for_add_new_staff();
        $this->browse(function (Browser $browser) {
            $staff_id = User::latest()->first()->id;
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test99@test.com')
                ->pause(1000)
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > button')
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(11) > div > div > a:nth-child(3)')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body > div.mt-40.d-flex.justify-content-between', function($modal){
                    $modal->pause(5000)
                        ->click('#delete_link')
                        ->assertPathIs('/hr/staffs');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });        
    }

    public function test_for_update_status(){
        $this->test_for_add_new_staff();
        $this->browse(function (Browser $browser) {
            $staff_id = User::latest()->first()->id;
            $browser->type('#DataTables_Table_0_filter > label > input[type=search]', 'test99@test.com')
                ->pause(6000)
                ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(8) > label > div')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });        
    }


}
